<?php
/*
 * Copyright © 2018-2026 RBSoft (Ravi Patel). All rights reserved.
 *
 * Author: Ravi Patel
 * Website: https://rbsoft.org/downloads/sms-gateway
 *
 * This software is licensed, not sold. Buyers are granted a limited, non-transferable license
 * to use this software exclusively on a single domain, subdomain, or computer. Usage on
 * multiple domains, subdomains, or computers requires the purchase of additional licenses.
 *
 * Redistribution, resale, sublicensing, or sharing of the source code, in whole or in part,
 * is strictly prohibited. Modification (except for personal use by the licensee), reverse engineering,
 * or creating derivative works based on this software is strictly prohibited.
 *
 * Unauthorized use, reproduction, or distribution of this software may result in severe civil
 * and criminal penalties and will be prosecuted to the fullest extent of the law.
 *
 * For licensing inquiries or support, please visit https://support.rbsoft.org.
 */

try {
    require_once __DIR__ . "/../includes/ajax_protect.php";
    require_once __DIR__ . "/../includes/login.php";

    if (!isset($_REQUEST["lastId"]) || !ctype_digit($_REQUEST["lastId"])) {
        throw new Exception("Invalid lastId");
    }

    $lastId = $_REQUEST["lastId"];
    $messages = Message::where("status", "Received")
        ->where("userID", $_SESSION["userID"])
        ->where("ID", $lastId, ">")
        ->read_all();

    $numbers = [];
    foreach ($messages as $message) {
        if (in_array($message->getNumber(), $numbers)) {
            continue;
        }
        $numbers[] = $message->getNumber();
    }

    /** @var User $logged_in_user */
    $contacts = $logged_in_user->getContacts($numbers);
    foreach ($messages as $message) {
        if ($message->getID() > $lastId) {
            $lastId =  $message->getID();
        }
    }

    echo json_encode([
        "result" => [
            "lastId" => $lastId,
            "messages" => array_map(fn($message) => [
                "number" => isset($contacts[$message->getNumber()]) ? $contacts[$message->getNumber()] . " ({$message->getNumber()})" : $message->getNumber(),
                "message" => $message->getMessage()
            ], $messages)
        ]
    ]);
} catch (Throwable $t) {
    echo json_encode(array(
        'error' => $t->getMessage()
    ));
}