<?php
/*
 * Copyright © 2018-2026 RBSoft (Ravi Patel). All rights reserved.
 *
 * Author: Ravi Patel
 * Website: https://rbsoft.org/downloads/sms-gateway
 *
 * This software is licensed, not sold. Buyers are granted a limited, non-transferable license
 * to use this software exclusively on a single domain, subdomain, or computer. Usage on
 * multiple domains, subdomains, or computers requires the purchase of additional licenses.
 *
 * Redistribution, resale, sublicensing, or sharing of the source code, in whole or in part,
 * is strictly prohibited. Modification (except for personal use by the licensee), reverse engineering,
 * or creating derivative works based on this software is strictly prohibited.
 *
 * Unauthorized use, reproduction, or distribution of this software may result in severe civil
 * and criminal penalties and will be prosecuted to the fullest extent of the law.
 *
 * For licensing inquiries or support, please visit https://support.rbsoft.org.
 */

try {
    require_once __DIR__ . "/../includes/ajax_protect.php";
    require_once __DIR__ . "/../includes/login.php";

    if ($_SESSION["isAdmin"]) {
        if (isset($_POST["application_title"]) && isset($_POST["license_code"])) {
            User::isValidDelay($_POST["default_delay"]);
            $uploads = ["logo_src", "favicon_src"];
            foreach ($uploads as $upload) {
                if (isset($_FILES[$upload]['tmp_name']) && is_uploaded_file($_FILES[$upload]['tmp_name'])) {
                    $tempPath = $_FILES[$upload]['tmp_name'];
                    $filename = basename($_FILES[$upload]['name']);
                    $fileExtension = pathinfo($_FILES[$upload]['name'], PATHINFO_EXTENSION);
                    $allowed_extensions = ["png", "jpg", "jpeg", 'ico'];
                    if (!in_array($fileExtension, $allowed_extensions)) {
                        throw new Exception(__("error_blocked_file_extension"));
                    }
                    $uploadDirectory = __DIR__ . "/../uploads";
                    if (is_dir($uploadDirectory) || mkdir($uploadDirectory, 0755)) {
                        if (move_uploaded_file($tempPath, "{$uploadDirectory}/{$filename}")) {
                            $_POST[$upload] = "uploads/{$filename}";
                        } else {
                            throw new Exception(__("error_uploading_logo"));
                        }
                    } else {
                        throw new Exception(__("error_creating_directory", ["name" => "upload"]));
                    }
                }
            }
            if ($json = getFirebaseServiceAccountJson()) {
                $_POST["firebase_service_account_json"] = $json;
            }
            $oldPaypalClientID = Setting::get("paypal_client_id");
            $oldPaypalSecret = Setting::get("paypal_secret");
            MysqliDb::getInstance()->startTransaction();
            if (!isset($_POST["default_credits"])) {
                $_POST["default_credits"] = null;
            }
            if (!isset($_POST["default_devices_limit"])) {
                $_POST["default_devices_limit"] = null;
            }
            if (!isset($_POST["default_contacts_limit"])) {
                $_POST["default_contacts_limit"] = null;
            }
            Setting::apply($_POST);
            if (!empty($_POST["paypal_enabled"]) && !empty($_POST["paypal_client_id"]) && !empty($_POST["paypal_secret"])) {
                if ($oldPaypalClientID != $_POST["paypal_client_id"] || $oldPaypalSecret != $_POST["paypal_secret"]) {
                    $serverUrl = getServerURL();
                    if (str_starts_with($serverUrl, "https")) {
                        PayPal::createProduct($serverUrl);
                        $paymentWebhook = PayPal::createWebHook(["PAYMENT.SALE.COMPLETED", "PAYMENT.SALE.REVERSED", "PAYMENT.SALE.REFUNDED"], sprintf("%s/webhooks/payment-sale-completed.php", $serverUrl));
                        $subscriptionWebhook = PayPal::createWebHook(["BILLING.SUBSCRIPTION.CANCELLED", "BILLING.SUBSCRIPTION.PAYMENT.FAILED"], sprintf("%s/webhooks/billing-subscription-cancelled.php", $serverUrl));
                        Setting::apply([
                            "paypal_subscription_webhook_id" => $subscriptionWebhook->id,
                            "paypal_payment_webhook_id" => $paymentWebhook->id
                        ]);
                        $plans = Plan::read_all();
                        foreach ($plans as $plan) {
                            $plan->setPaypalPlanID(PayPal::createPlan($serverUrl, $plan));
                            $plan->save();
                        }
                    } else {
                        throw new Exception(__("error_paypal_requires_ssl"));
                    }
                }
            }
            MysqliDb::getInstance()->commit();
            echo json_encode([
                "result" => __("success_save_settings")
            ]);
        }
    }
} catch (Throwable $t) {
    echo json_encode(array(
        'error' => $t->getMessage()
    ));
}
