<?php
/*
 * Copyright © 2018-2026 RBSoft (Ravi Patel). All rights reserved.
 *
 * Author: Ravi Patel
 * Website: https://rbsoft.org/downloads/sms-gateway
 *
 * This software is licensed, not sold. Buyers are granted a limited, non-transferable license
 * to use this software exclusively on a single domain, subdomain, or computer. Usage on
 * multiple domains, subdomains, or computers requires the purchase of additional licenses.
 *
 * Redistribution, resale, sublicensing, or sharing of the source code, in whole or in part,
 * is strictly prohibited. Modification (except for personal use by the licensee), reverse engineering,
 * or creating derivative works based on this software is strictly prohibited.
 *
 * Unauthorized use, reproduction, or distribution of this software may result in severe civil
 * and criminal penalties and will be prosecuted to the fullest extent of the law.
 *
 * For licensing inquiries or support, please visit https://support.rbsoft.org.
 */

require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../vendor/autoload.php";

date_default_timezone_set(TIMEZONE);

try {
    if (isset($_POST["messages"])) {
        $messages = json_decode($_POST["messages"], true);
        if (is_array($messages) && count($messages) > 0) {
            MysqliDb::getInstance()->startTransaction();
            foreach ($messages as $message) {
                if (isset($message["ID"]) && isset($message["status"])) {
                    $obj = new Message();
                    $obj->setID($message["ID"]);
                    if ($obj->read()) {
                        $obj->setStatus($message["status"]);
                        if (isset($message["deliveredDate"])) {
                            $time = new DateTime($message["deliveredDate"]);
                            $time->setTimezone(new DateTimeZone(TIMEZONE));
                            $obj->setDeliveredDate($time->format("Y-m-d H:i:s"));
                        }
                        if (isset($message["resultCode"])) {
                            $obj->setResultCode($message["resultCode"]);
                        }
                        if (isset($message["errorCode"])) {
                            $obj->setErrorCode($message["errorCode"]);
                        }
                        if (array_key_exists("simSlot", $message)) {
                            $obj->setSimSlot($message["simSlot"]);
                        }
                        $obj->save();
                    }
                } else {
                    throw new Exception(__("error_invalid_request_format"));
                }
            }
            /* Uncomment this block if you want to send webhook on message status change.
            $messageObjects = [];
            foreach ($messages as $message) {
                $obj = new Message();
                $obj->setID($message["ID"]);
                $obj->read();
                $messageObjects[$obj->userID] = $message;
            }
            foreach ($messageObjects as $userID => $data) {
                $user = new User();
                $user->setID($userID);
                if ($user->read()) {
                    $user->callWebhook('messages', $data);
                }
            }
            */
            MysqliDb::getInstance()->commit();
        } else {
            throw new Exception(__("error_invalid_request_format"));
        }
        echo json_encode(["success" => true, "data" => null, "error" => null]);
    }
} catch (Throwable $t) {
    echo json_encode(["success" => false, "data" => null, "error" => ["code" => 500, "message" => $t->getMessage()]]);
}